package com.example.tp6_02.service;

import android.graphics.Bitmap;
import com.example.tp6_02.dto.CityDTO;
import com.example.tp6_02.dto.Mapper;
import com.example.tp6_02.dto.WeatherConditionDTO;
import com.example.tp6_02.json.JsonHandler;
import com.example.tp6_02.model.City;
import com.example.tp6_02.network.HttpOperation;

import java.util.List;

public class RequestService {

    private static void getBitmapIcons(CityDTO city) {
        List<WeatherConditionDTO> weather = city.getWeather();
        for (WeatherConditionDTO day : weather) {
            if (day.getIcon() == null) {
                Bitmap icon = HttpOperation.getIcon(day.getIconUrl());
                city.setWeatherConditionIcon(day.getIconUrl(), icon);
            }
        }
    }

    private static CityDTO _getCityWeatherConditions(String urlStr) {
        CityDTO city = null;
        try {
            String jsonString = HttpOperation.get(urlStr);
            city = JsonHandler.deSerializeJson2CityDTO(jsonString);
            if (city != null) {
                getBitmapIcons(city);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return city;
    }

    public static City getCityWeatherConditions(String urlStr) {
        CityDTO cityDTO = _getCityWeatherConditions(urlStr);
        City city = Mapper.cityDTO2city(cityDTO);
        return city;

    }
}
